/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230425
* Description : 演示FVR输出电压测试功能，可通过函数配置选择不同的输入通道和放大倍数，通过PB3引脚测量输出电压
********************************************************************************/
#include "AD18F08.h"
#include "fvr.h"
#include <stdio.h>

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_OFF        :  LVR使能位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL_LOW		    :  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _MTPDIS_OFF       ： SWD模式下读FLASH和EEPROM控位
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L    & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                     );


void main(void)
{

	GPIO_INIT();//GPIO初始化


	//DACCON = 0XDF;//Vdac=1/2Vdd

	//配置信息选择
	//Sel<2:0> (输入通道选择):1-VREF1P0,2-1/4VDD,3-NTC,4-DACOUT
	//Mode<4:3>(放大倍数选择):0-1倍,1-1倍,2-2倍,3-3倍
	//Mode<5>  (FVR模块使能) :0-关闭FVR,1-使能FVR
	//Mode<6>  (FVR输出使能) :0-不输出FVR,1-输出FVR（PB3）

	//      VREF1P0	 	0-1倍 使能FVR 输出FVR（PB3）
	FVR_Cfg(  1     ,     ((0<<3)|(1<<5)|(1<<6))       ) ;
	//      通道选择	放大倍数选择 模块使能 输出使能
	while(1);
}


//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断



}

//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}


